# [[

> Comprueba los tipos de archivo y compara los valores.
> Devuelve 0 si la condición es verdadera, 1 si es falsa.
> Más información: <https://gnu.org/software/bash/manual/bash.html#index-_005b_005b>.

- Comprueba si una variable dada es igual/no igual a la cadena especificada:

`[[ ${{variable}} {{==|!=}} "{{cadena}}" ]]`

- Comprueba si una cadena dada se ajusta al glob/`regex` especificado:

`[[ ${{variable}} {{==|=~}} {{patron}} ]]`

- Comprueba si una variable dada es [eq]ual/[n]ot [e]qual/[g]reater [t]han/[l]ess [t]han/[g]reater than o [e]qual/[l]ess than o [e]qual al número especificado:

`[[ ${{variable}} -{{eq|ne|gt|lt|ge|le}} {{integer}} ]]`

- Comprueba si la variable especificada tiene un valor [n]o-vacío:

`[[ -n ${{variable}} ]]`

- Comprueba si la variable especificada tiene un valor vacío:

`[[ -z ${{variable}} ]]`

- Comprueba si el [f]ile especificado existe:

`[[ -f {{ruta/al/archivo}} ]]`

- Comprueba si existe el [d]irectorio especificado:

`[[ -d {{ruta/al/directorio}} ]]`

- Comprueba si [e]xiste el archivo o directorio especificado:

`[[ -e {{ruta/al/archivo_o_directorio}} ]]`
